# Contribuindo (*Contributing*)

Todas as contribuições são **bem vindas** e serão totalmente **creditadas** aos seus autores.
*Contributions are **welcome** and will be fully **credited**.*

Nós aceitamos contribuições via "pull request" através do repositório no [GitHub](https://github.com/nfephp-org/posprint).
*We accept contributions via Pull Requests on [Github](https://github.com/nfephp-org/posprint).*


## Carregando o repositório origem

Para manter seu fork atualizado é necessário configurar um branch **upstream** com o repositório origem do seu fork.
*To keep your fork updated, you need to configure an **upstream** branch in your forked repository.*

``` bash
$ git remote add upstream git@github.com:nfephp-org/nfephp.git
$ git fetch upstream
```

Sempre antes de iniciar qualquer modificação atualize seu fork
*Always update your fork before doing any modification*

``` bash
$ git checkout master
$ git fetch upstream
$ git merge upstream/master
$ git push origin master
```


## Pull Requests

- **[PSR-2 Coding Standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)** - A forma mais facil de aplicar as convenções é atraves do PHP Code Sniffer. *The easiest way to apply the conventions is to install [PHP Code Sniffer](http://pear.php.net/package/PHP_CodeSniffer).*

- **Add tests!** - Seus patch não serão aceitos caso não tenham testes. *Your patch won't be accepted if it doesn't have tests.*

- **Document any change in behaviour** - Tenha certeza de manter o `README.md` e qualquer outra documentação relevante atualizada com o seu patch. *Make sure the `README.md` and any other relevant documentation are kept up-to-date.*

- **Consider our release cycle** - Nós tentamos seguir a especificação SemVer v2.0.0. Quebrar aleatóriamente uma API publica não é uma opção. *We try to follow [SemVer v2.0.0](http://semver.org/). Randomly breaking public APIs is not an option.*

- **Create feature branches** - Não nos peça para puxar do seu branch master. *Don't ask us to pull from your master branch.*

- **One pull request per feature** - Se você quiser fazer mais de uma coisa, envie várias solicitações de pull, não coloque tudo de uma vez. *If you want to do more than one thing, send multiple pull requests.*

- **Send coherent history** - Certifique-se que cada commit individual em seu pull request é significativo. Se você tivesse que fazer várias commits intermediários durante o desenvolvimento, por favor junte antes de submeter.  *Make sure each individual commit in your pull request is meaningful. If you had to make multiple intermediate commits while developing, please [squash them](http://www.git-scm.com/book/en/v2/Git-Tools-Rewriting-History#Changing-Multiple-Commit-Messages) before submitting.*


## Running Tests

``` bash
$ composer test
```


**Happy coding**!