<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">

	<div class="card-body">
		<div class="">
			<div class="col-12">
				<a href="<?php echo e(route('ifood.new-orders')); ?>" class="btn btn-lg btn-danger btn-refresh spinner-white spinner-right">
					<i class="fa fa-refresh"></i>Atualizar/Buscar Pedidos
				</a>
			</div>
		</div>
		<br>
		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

				<form method="get" action="/ifood/pedidosFilter">
					<div class="row align-items-center">
						<div class="col-lg-4 col-xl-4">
							<div class="row align-items-center">
								<div class="col-md-12 my-2 my-md-0">
									<label>Nome do cliente</label>
									<input type="text" name="search" class="form-control" value="<?php echo e(isset($search) ? $search : ''); ?>" id="">
								</div>
							</div>
						</div>

						<div class="col-lg-2">
							<div class="row align-items-center">
								<div class="col-md-12 my-2 my-md-0">
									<label>Status</label>
									<select class="form-control" name="status">
										<option value="">Todos</option>
										<option <?php if(isset($status)): ?> <?php if($status == 'PLC'): ?> selected <?php endif; ?> <?php endif; ?> value="PLC">Novo pedido</option>
										<option <?php if(isset($status)): ?> <?php if($status == 'CFM'): ?> selected <?php endif; ?> <?php endif; ?> value="CFM">Confirmado</option>
										<option <?php if(isset($status)): ?> <?php if($status == 'RTP'): ?> selected <?php endif; ?> <?php endif; ?> value="RTP">Pronto para ser retirado</option>
										<option <?php if(isset($status)): ?> <?php if($status == 'DSP'): ?> selected <?php endif; ?> <?php endif; ?> value="DSP">Saiu para entrega</option>
										<option <?php if(isset($status)): ?> <?php if($status == 'CON'): ?> selected <?php endif; ?> <?php endif; ?> value="CON">Concluído</option>
										<option <?php if(isset($status)): ?> <?php if($status == 'CAN'): ?> selected <?php endif; ?> <?php endif; ?> value="CAN">Cancelados</option>
									</select>
								</div>
							</div>
						</div>
						<div class="col-lg-2 col-xl-2">
							<button style="margin-top: 25px;" type="submit" class="btn btn-light-primary font-weight-bold">Pesquisa</button>
						</div>
					</div>
				</form>
			</div>
			<br>
			<h4>Lista de Produtos iFood</h4>
			<?php if(isset($links)): ?>
			<label class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">Total de pedidos: <strong class="text-success"><?php echo e(($data->total())); ?></strong></label>
			<?php endif; ?>
			<div class="row">

				<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<!-- inicio grid -->
				<div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
					<!--begin::Card-->
					<div class="card card-custom gutter-b card-stretch">
						<!--begin::Body-->
						<div class="card-body pt-4">
							<!--begin::Toolbar-->
							<div class="d-flex justify-content-end">
								<div class="dropdown dropdown-inline" data-toggle="tooltip" title="" data-placement="left" >
									<a href="#" class="btn btn-clean btn-hover-light-primary btn-sm btn-icon" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										<i class="fa fa-ellipsis-h"></i>
									</a>
									<div class="dropdown-menu dropdown-menu-md dropdown-menu-right">
										<!--begin::Navigation-->
										<ul class="navi navi-hover">
											<li class="navi-header font-weight-bold py-4">
												<span class="font-size-lg">Ações:</span>
												
											</li>
											<li class="navi-separator mb-3 opacity-70"></li>

											<li class="navi-item">
												<a href="/ifood/pedidosDetail/<?php echo e($item->id); ?>" class="navi-link">
													<span class="navi-text">
														<span class="label label-xl label-inline label-light-info">Detalhes do pedido</span>
													</span>
												</a>
											</li>
											
										</ul>
										<!--end::Navigation-->
									</div>
								</div>
							</div>
							<!--end::Toolbar-->
							<!--begin::User-->
							<div class="d-flex align-items-end mb-7">
								<!--begin::Pic-->
								<div class="d-flex align-items-center">
									<!--begin::Pic-->
									<!--end::Pic-->
									<!--begin::Title-->
									<div class="d-flex flex-column">
										<a class="text-dark font-weight-bold text-hover-primary font-size-h4 mb-0">
											<?php echo e($item->pedido_id); ?>

										</a>

									</div>
									<!--end::Title-->
								</div>
								<!--end::Title-->
							</div>
							<!--end::User-->
							<!--begin::Desc-->

							<p class="text-muted font-weight-bold">Cliente: 
								<strong class="text-info"> <?php echo e($item->nome_cliente ?? '--'); ?></strong>
							</p>

							<p class="text-muted font-weight-bold">Valor: 
								<strong class="text-danger"> R$ <?php echo e(number_format($item->valor_total, 2, ',', '.')); ?></strong>
							</p>
							<p class="text-muted font-weight-bold">Status:
								<?php if($item->status == 'CAN'): ?>
								<strong class="text-danger"> <?php echo e($item->status); ?></strong>
								<?php elseif($item->status == 'CFM'): ?>
								<strong class="text-success"> <?php echo e($item->status); ?></strong>
								<?php else: ?>
								<strong class="text-info"> <?php echo e($item->status); ?></strong>
								<?php endif; ?>
							</p>
							<p class="text-muted font-weight-bold">Data: 
								<strong class="text-danger"> 
									<?php echo e(\Carbon\Carbon::parse($item->data_pedido)->format('d/m/Y H:i')); ?>

								</strong>
							</p>

						</div>
						<!--end::Body-->
					</div>
					<!--end::Card-->
				</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>

			<div class="d-flex justify-content-between align-items-center flex-wrap">
				<div class="d-flex flex-wrap py-2 mr-3">
					<?php if(isset($links)): ?>
					<?php echo e($data->links()); ?>

					<?php endif; ?>
				</div>
			</div>
			
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
	$('.btn-refresh').click(() => {
		$('.btn-refresh').addClass('spinner')
	})
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/pedido_ifood/index.blade.php ENDPATH**/ ?>