<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">

	<div class="card-body">
		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">
			<div class="col-lg-12" id="content">
				<!--begin::Portlet-->

				<h2 class="card-title">Total de vendas: <strong class="text-info"><?php echo e(sizeof($vendas)); ?></strong></h2>

				<?php if($abertura != null): ?>
				<h3>Inicio do caixa: <strong class="text-success"><?php echo e(\Carbon\Carbon::parse($abertura->created_at)->format('d/m/Y H:i:s')); ?></strong></h3>

				<div class="row">
					<div class="col-xl-12">
						<h3 class="text-info">Total por tipo de pagamento:</h3>
						<div class="kt-section kt-section--first">
							<div class="kt-section__body">
								<div class="row">

									<?php $__currentLoopData = $somaTiposPagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php if($tp > 0): ?>
									<div class="col-sm-4 col-lg-4 col-md-6">
										<div class="card card-custom gutter-b">
											<div class="card-header">
												<h3 class="card-title">
													<?php echo e(App\Models\VendaCaixa::getTipoPagamento($key)); ?>

												</h3>
											</div>
											<div class="card-body">
												<h4 class="text-success">R$ <?php echo e(number_format($tp, 2, ',', '.')); ?></h4>
											</div>

										</div>
									</div>
									<?php endif; ?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

								</div>
							</div>
						</div>
					</div>
				</div>


				<div class="row">
					<div class="col-xl-12">

						<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

							<table class="datatable-table" style="max-width: 100%; overflow: scroll">
								<thead class="datatable-head">
									<tr class="datatable-row" style="left: 0px;">
										
										<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Cliente</span></th>
										<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Data</span></th>
										<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Tipo de pagamento</span></th>

										<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Estado</span></th>

										<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">NFCe/NFe</span></th>

										<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Tipo</span></th>

										<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor</span></th>
									</tr>
								</thead>

								<tbody class="datatable-body">
									<?php
									$soma = 0;
									?>
									<?php $__currentLoopData = $vendas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

									<tr class="datatable-row" >
										
										<td class="datatable-cell"><span class="codigo" style="width: 150px;"><?php echo e($v->cliente->razao_social ?? 'NAO IDENTIFCADO'); ?></span>
										</td>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e(\Carbon\Carbon::parse($v->created_at)->format('d/m/Y H:i:s')); ?></span>
										</td>
										<td class="datatable-cell">
											<span class="codigo" style="width: 100px;">

												<?php if($v->tipo_pagamento == '99'): ?>

												<a href="#!" onclick='swal("", "<?php echo e($v->multiplo()); ?>", "info")' class="btn btn-light-info">
													Ver
												</a>
												<?php else: ?>
												<?php echo e($v->getTipoPagamento($v->tipo_pagamento)); ?>

												<?php endif; ?>

											</span>
										</td>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->estado); ?></span>
										</td>
										<?php if($v->tipo == 'PDV'): ?>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->NFcNumero > 0 ? $v->NFcNumero : '--'); ?></span>
										</td>
										<?php else: ?>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->NfNumero > 0 ? $v->NfNumero : '--'); ?></span>
										</td>
										<?php endif; ?>

										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->tipo); ?></span>
										</td>

										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e(number_format($v->valor_total, 2, ',', '.')); ?></span>
										</td>

										<?php
										if(!$v->consignado && !$v->rascunho)
										$soma += $v->valor_total;
										?>

									</tr>

									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

								</tbody>
							</table>
						</div>
					</div>
				</div>
				<br>

				<?php if(sizeof($vendas) == 0): ?>
				<h2 class="text-danger text-center">NÃO É POSSÍVEL FECAR SEM NENHUMA VENDA</h2>
				<?php else: ?>
				<h4 class="text-info">Soma: <strong><?php echo e(number_format($soma, 2, ',', '.')); ?></strong></h4>
				<?php endif; ?>
				<div class="row">
					<form id="form-caixa" method="post" action="/frenteCaixa/fechar">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="abertura_id" value="<?php echo e($abertura->id); ?>">
						<button <?php if(sizeof($vendas) == 0): ?> disabled <?php endif; ?> class="btn btn-lg btn-danger" type="button" id="btn-fechar-caixa">
							<i class="la la-times"></i>
							Fechar Caixa
						</button>
					</form>
				</div>
				<?php else: ?>
				<h3 class="text-danger">Caixa fechado!</h3>
				<?php endif; ?>

			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>	
<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
	$('#btn-fechar-caixa').click(() => {
		swal("Atenção!", "Deseja fechar o caixa?", "warning")
		.then((sim) => {
			if(sim){
				$('#form-caixa').submit()
			}
		})
	})
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/frontBox/fechar_caixa.blade.php ENDPATH**/ ?>